/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.CrystalPurificationStationContainer;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.tileentity.CrystalPurificationStationTileEntity;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_PurifyPacket;
import dev.toma.gunsrpg.resource.perks.PurificationConfiguration;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CrystalPurificationStationScreen
extends ContainerScreen<CrystalPurificationStationContainer> {
    private static final ResourceLocation BG = GunsRPG.makeResource("textures/screen/purification_station.png");
    private static final ITextComponent BUTTON_PURIFY = new TranslationTextComponent("screen.button.purify_crystal");
    private final ItemStack renderItem = new ItemStack((IItemProvider)ModItems.PERKPOINT_BOOK);
    private IPlayerData data;
    private Button purifyButton;

    public CrystalPurificationStationScreen(CrystalPurificationStationContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = 164;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.data = PlayerData.getUnsafe((PlayerEntity)this.field_230706_i_.field_71439_g);
        this.purifyButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 26, this.field_147009_r + 29, 37, 20, BUTTON_PURIFY, this::purifyButtonClicked));
        this.updateButtonState();
    }

    protected void func_230450_a_(MatrixStack matrix, float partialRenderTicks, int mouseX, int mouseY) {
        PurificationConfiguration.Entry entry;
        this.field_230706_i_.func_110434_K().func_110577_a(BG);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_230706_i_.func_175599_af().func_175042_a(this.renderItem, this.field_147003_i + this.field_146999_f - 22, this.field_147009_r + 63);
        IPerkProvider provider = this.data.getPerkProvider();
        String text = String.valueOf(provider.getPoints());
        int fundsWidth = this.field_230712_o_.func_78256_a(text);
        this.field_230712_o_.func_238421_b_(matrix, text, (float)(this.field_147003_i + this.field_146999_f - 24 - fundsWidth), (float)(this.field_147009_r + 68), 43775);
        CrystalPurificationStationTileEntity tile = (CrystalPurificationStationTileEntity)((Object)((CrystalPurificationStationContainer)this.field_147002_h).getTileEntity());
        int orbs = tile.getOrbCount();
        int price = tile.getPrice(orbs);
        if (price > -1) {
            String priceText = "\u6210\u672c: " + price;
            this.field_230712_o_.func_238421_b_(matrix, priceText, (float)(this.field_147003_i + 8), (float)(this.field_147009_r + 68), 0x404040);
        }
        if ((entry = GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration().getPurificationConfig().getValueForAmount(orbs)) != null && !tile.getItemHandler().getStackInSlot(1).func_190926_b()) {
            float successChance = entry.getSuccessChance();
            String chance = "\u6210\u529f\u7387:";
            this.field_230712_o_.func_238421_b_(matrix, chance, (float)(this.field_147003_i + 125), (float)(this.field_147009_r + 15), 43520);
            int chanceWidth = this.field_230712_o_.func_78256_a(chance);
            String chanceAmount = Math.round(successChance * 100.0f) + "%";
            int chanceAmountWidth = this.field_230712_o_.func_78256_a(chanceAmount);
            this.field_230712_o_.func_238421_b_(matrix, chanceAmount, (float)(this.field_147003_i + 125) + (float)(chanceWidth - chanceAmountWidth) / 2.0f, (float)(this.field_147009_r + 25), 43520);
            String breakChance = "\u7834\u788e\u7387:";
            int breakChanceWidth = this.field_230712_o_.func_78256_a(breakChance);
            String breakChanceAmount = Math.round(entry.getBreakChance() * 100.0f) + "%";
            int breakChanceAmountWidth = this.field_230712_o_.func_78256_a(breakChanceAmount);
            this.field_230712_o_.func_238421_b_(matrix, breakChance, (float)(this.field_147003_i + 125) + (float)(chanceWidth - breakChanceWidth) / 2.0f, (float)(this.field_147009_r + 40), 0x404040);
            this.field_230712_o_.func_238421_b_(matrix, breakChanceAmount, (float)(this.field_147003_i + 125) + (float)(chanceWidth - breakChanceAmountWidth) / 2.0f, (float)(this.field_147009_r + 50), 0x404040);
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    protected void func_184098_a(Slot slot, int mouseX, int mouseY, ClickType clickType) {
        super.func_184098_a(slot, mouseX, mouseY, clickType);
        this.updateButtonState();
    }

    private void purifyButtonClicked(Button button) {
        NetworkManager.sendServerPacket(new C2S_PurifyPacket(((CrystalPurificationStationTileEntity)((Object)((CrystalPurificationStationContainer)this.field_147002_h).getTileEntity())).func_174877_v()));
        this.updateButtonState();
    }

    private void updateButtonState() {
        this.purifyButton.field_230693_o_ = ((CrystalPurificationStationTileEntity)((Object)((CrystalPurificationStationContainer)this.field_147002_h).getTileEntity())).canPurify(this.data.getPerkProvider());
    }
}

